/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.resourcestab;

import filenet.sim.api.VWScenarioResourceAssignment;
import filenet.sim.api.VWScenarioRoleAssignment;
import filenet.sim.api.VWScenarioShiftDefinition;
import filenet.vw.api.VWException;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.IVWSortItem;

class VWSIMResourceAssignmentWrapper
implements IVWSortItem {
    protected static final int SHIFT_NAMES = 0;
    protected static final int RESOURCE_NAMES = 1;
    private VWScenarioShiftDefinition m_shiftDef = null;
    private VWScenarioRoleAssignment m_roleAssignment = null;
    private VWScenarioResourceAssignment m_resourceAssignment = null;
    private int m_nMode = -1;

    public VWSIMResourceAssignmentWrapper(VWScenarioShiftDefinition shiftDef, VWScenarioRoleAssignment roleAssignment, VWScenarioResourceAssignment resAssignment, int nMode) {
        this.m_shiftDef = shiftDef;
        this.m_roleAssignment = roleAssignment;
        this.m_resourceAssignment = resAssignment;
        this.m_nMode = nMode;
    }

    public String getResourceName() {
        if (this.m_resourceAssignment != null) {
            return this.m_resourceAssignment.getResourceName();
        }
        return null;
    }

    public String getShiftName() {
        if (this.m_shiftDef != null) {
            return this.m_shiftDef.getName();
        }
        return null;
    }

    public String getRoleName() {
        if (this.m_roleAssignment != null) {
            return this.m_roleAssignment.getRoleName();
        }
        return null;
    }

    public void setRoleName(String newRoleName) throws VWException {
        if (this.m_shiftDef != null) {
            if (this.m_roleAssignment != null && VWStringUtils.compare(this.m_roleAssignment.getRoleName(), newRoleName) == 0) {
                return;
            }
            this.delete();
            VWScenarioRoleAssignment roleAssignment = null;
            try {
                roleAssignment = this.m_shiftDef.getRoleAssignment(newRoleName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (roleAssignment == null) {
                roleAssignment = this.m_shiftDef.createRoleAssignment(newRoleName);
            }
            this.m_resourceAssignment = roleAssignment.createResourceAssignment(this.m_resourceAssignment.getResourceName(), this.m_resourceAssignment.getPerformance());
            this.m_roleAssignment = roleAssignment;
        }
    }

    public String getPerformance() {
        if (this.m_resourceAssignment != null) {
            double ratio = this.m_resourceAssignment.getPerformance();
            if (ratio > 0.0) {
                ratio = 100.0 / ratio + 0.005;
                int intRatio = (int)(100.0 * ratio);
                ratio = (double)intRatio / 100.0;
            }
            return Double.toString(ratio);
        }
        return null;
    }

    public void setPerformance(String newPerformance) throws Exception {
        if (this.m_resourceAssignment != null) {
            float performance = Float.parseFloat(newPerformance);
            if ((double)performance < 1.0 || (double)performance > 1000.0) {
                throw new VWException("sim.toolkit.designer.properties.resourcestab.InvalidPerformance", "The job efficiency value must be between 1 and 1000.");
            }
            this.m_resourceAssignment.setPerformance(100.0f / performance);
        }
    }

    public void delete() throws VWException {
        if (this.m_shiftDef != null && this.m_roleAssignment != null) {
            this.m_roleAssignment.deleteResourceAssignment(this.m_resourceAssignment.getResourceName());
            VWScenarioResourceAssignment[] resourceAssignments = this.m_roleAssignment.getResourceAssignments();
            if (resourceAssignments == null || resourceAssignments != null && resourceAssignments.length == 0) {
                this.m_shiftDef.deleteRoleAssignment(this.m_roleAssignment.getRoleName());
            }
            this.m_roleAssignment = null;
        }
    }

    public String getName() {
        switch (this.m_nMode) {
            case 0: {
                return this.getShiftName();
            }
            case 1: {
                return this.getResourceName();
            }
        }
        return null;
    }
}

